/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher;

import com.oxaion.tools.weblauncher.LauncherWindow;
import com.oxaion.tools.weblauncher.Manager;
import com.oxaion.tools.weblauncher.UpdateTask;
import com.oxaion.tools.weblauncher.data.Configuration;
import com.oxaion.tools.weblauncher.data.File;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class Main
extends JPanel
implements LauncherWindow {
    private JProgressBar progressBar;
    private ImageIcon image;
    private boolean imageLoaded = false;
    private static final String clientArgumentPrefix = "javaws.clientArg.";
    private long currentProgress;

    public Main() {
        this.setLayout(null);
        UIManager.put("ProgressBarUI", BasicProgressBarUI.class.getCanonicalName());
        UIManager.put("ToolTipUI", BasicToolTipUI.class.getCanonicalName());
        UIManager.put("ProgressBar.border", BorderFactory.createMatteBorder(1, 0, 1, 0, Color.gray));
        UIManager.put("ProgressBar.background", Color.white);
        UIManager.put("ProgressBar.foreground", Color.lightGray);
        UIManager.put("ProgressBar.selectionForeground", Color.darkGray);
        UIManager.put("ProgressBar.selectionBackground", Color.darkGray);
        UIManager.put("ToolTip.background", Color.lightGray);
        UIManager.put("ToolTip.foreground", Color.darkGray);
        UIManager.put("ToolTip.border", BorderFactory.createLineBorder(Color.darkGray, 1));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setBounds(Integer.getInteger("splashScreen.progress.x", 0), Integer.getInteger("splashScreen.progress.y", 204), Integer.getInteger("splashScreen.progress.width", 440), Integer.getInteger("splashScreen.progress.height", 41));
        this.add(this.progressBar);
        this.image = this.loadSplashScreenImage();
        if (this.image != null) {
            this.setPreferredSize(new Dimension(this.image.getIconWidth() - 2, this.image.getIconHeight() - 2));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.imageLoaded) {
            this.image = this.loadSplashScreenImage();
            this.imageLoaded = true;
        }
        if (this.image != null) {
            g.drawImage(this.image.getImage(), -1, -1, this.image.getIconWidth(), this.image.getIconHeight(), null);
        }
    }

    private ImageIcon loadSplashScreenImage() {
        String splashPath = Main.getSystemProperty("splashScreen.path", "com/oxaion/tools/weblauncher/startscreen-opn.png");
        return this.loadImage(splashPath);
    }

    private ImageIcon loadLogo() {
        String splashPath = Main.getSystemProperty("logo.path", "com/oxaion/tools/weblauncher/logo-opn.png");
        return this.loadImage(splashPath);
    }

    public ImageIcon loadImage(String imagePath) {
        ClassLoader cl = this.getClass().getClassLoader();
        URL imageURL = cl.getResource(imagePath);
        if (imageURL == null) {
            return null;
        }
        return new ImageIcon(imageURL);
    }

    @Override
    public void setMaximum(long maximum) {
        this.progressBar.setMaximum((int)(maximum / 1024L));
    }

    @Override
    public void setValue(long value) {
        this.currentProgress = value;
        this.progressBar.setValue((int)(value / 1024L));
    }

    @Override
    public long getValue() {
        return this.currentProgress;
    }

    @Override
    public void setIndeterminate(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.progressBar.setIndeterminate(b);
            }
        });
    }

    @Override
    public void setStatusText(String text) {
        this.progressBar.setString(text);
    }

    public static void main(String[] args) {
        ArrayList<String> clientArgs = new ArrayList<String>();
        URL url = Main.extractParameters(args, clientArgs);
        if (url == null || !url.toString().endsWith(".xml")) {
            Manager.main(args);
            return;
        }
        JFrame frame = new JFrame("oxaion Weblauncher");
        Main progressIndicator = new Main();
        ImageIcon logo = progressIndicator.loadLogo();
        if (logo != null) {
            frame.setIconImage(logo.getImage());
        }
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)progressIndicator, "Center");
        frame.setDefaultCloseOperation(3);
        frame.setResizable(false);
        frame.pack();
        frame.pack();
        Main.center(frame);
        frame.setVisible(true);
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(clientArgumentPrefix)) continue;
            clientArgs.add(key.substring(clientArgumentPrefix.length()) + "=" + System.getProperty(key));
        }
        Configuration baseConfig = Main.configureBaseConfiguration(url);
        new UpdateTask(progressIndicator, baseConfig, clientArgs.toArray(new String[0])).start();
    }

    private static URL extractParameters(String[] args, List<String> clientArgs) {
        String s = null;
        try {
            if (args.length > 0 && !args[0].equals("+")) {
                for (String arg : args) {
                    if (arg.startsWith("wlaFile")) {
                        String wlaFilePath;
                        java.io.File wlaFile;
                        String[] wlafArg = arg.split("=");
                        if (wlafArg.length != 2 || !(wlaFile = new java.io.File(wlaFilePath = wlafArg[1])).exists()) continue;
                        try (BufferedReader in = new BufferedReader(new FileReader(wlaFile));){
                            while ((s = in.readLine()) != null) {
                                if (s.trim().isEmpty()) continue;
                                clientArgs.add(s);
                            }
                            continue;
                        }
                    }
                    clientArgs.add(arg);
                }
            } else {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("arguments.txt")));){
                    while ((s = in.readLine()) != null) {
                        if (s.startsWith("proxyHost=")) {
                            System.setProperty("http.proxyHost", s.substring(10));
                            System.setProperty("https.proxyHost", s.substring(10));
                            continue;
                        }
                        if (s.startsWith("proxyPort=")) {
                            System.setProperty("http.proxyPort", s.substring(10));
                            System.setProperty("https.proxyPort", s.substring(10));
                            continue;
                        }
                        if (s.trim().isEmpty()) continue;
                        clientArgs.add(s);
                    }
                }
                if (args.length > 0) {
                    for (int i = 1; i < args.length; ++i) {
                        clientArgs.add(args[i]);
                    }
                }
            }
            return new URL(clientArgs.remove(0));
        }
        catch (Exception e) {
            return null;
        }
    }

    static Configuration configureBaseConfiguration(URL url) {
        Configuration baseConfig = new Configuration();
        baseConfig.setProtocol(url.getProtocol());
        baseConfig.setHost(url.getHost());
        baseConfig.setPort(url.getPort() == -1 ? url.getDefaultPort() : url.getPort());
        String urlPath = url.getPath();
        baseConfig.setBasePath(urlPath.substring(0, urlPath.lastIndexOf(47)));
        baseConfig.setConfigFileName(urlPath.substring(urlPath.lastIndexOf(47)));
        return baseConfig;
    }

    public static void center(Window w) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = w.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        w.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static String getSystemProperty(String key) {
        String value = System.getProperty("jnlp." + key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static String getSystemProperty(String key, String defaultValue) {
        String value = Main.getSystemProperty(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public void showMessageDialog(String message, String string, int errorMessage) {
        JOptionPane.showMessageDialog(this, message, string, errorMessage);
    }

    @Override
    public int showConfirmDialog(String message, String string, int yesNoOption, int questionMessage) {
        return JOptionPane.showConfirmDialog(this, message, string, yesNoOption, questionMessage);
    }

    @Override
    public void exit(int code) {
        System.exit(code);
    }

    @Override
    public void startDownload(File file) {
    }

    static {
        if (System.getProperty("java.net.useSystemProxies") == null) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
    }
}

